/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.lang.reflect.Array;
import java.util.Formatter;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Static;

public final class Strings
extends Static {
    public static final char CONTINUATION_MARK = '\u2503';
    public static final char CONTINUATION_END = '\u2579';
    public static final String CONTINUATION_ITEM = "\u25b6\u00a0";

    private Strings() {
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        return string == string2 || string != null && string.equalsIgnoreCase(string2);
    }

    public static String orEmpty(String string) {
        return string != null ? string : "";
    }

    public static String trimOrNull(String string) {
        if (string != null && (string = CharSequences.trimWhitespaces(string.trim())).isEmpty()) {
            return null;
        }
        return string;
    }

    public static boolean appendUnicodeIdentifier(StringBuilder stringBuilder, char c, String string, String string2, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        if (string != null) {
            int n;
            for (int i = 0; i < string.length(); i += Character.charCount(n)) {
                boolean bl4;
                n = string.codePointAt(i);
                boolean bl5 = bl4 = stringBuilder.length() == 0;
                if ((!bl4 ? Character.isUnicodeIdentifierPart(n) : Character.isUnicodeIdentifierStart(n)) || string2.indexOf(n) >= 0) {
                    if (!bl4 && !bl2 && c != '\u0000') {
                        stringBuilder.append(c);
                    }
                    stringBuilder.appendCodePoint(bl ? Character.toLowerCase(n) : (bl3 ? Character.toUpperCase(n) : n));
                    bl2 = true;
                    bl3 = false;
                    continue;
                }
                bl3 = true;
            }
        }
        return bl2;
    }

    public static String toIndexed(String string, int n) {
        return string + '[' + n + ']';
    }

    public static String bracket(String string, Object object) {
        if (object instanceof CharSequence) {
            return string + "[\u201c" + object + "\u201d]";
        }
        return string + '[' + object + ']';
    }

    public static String bracket(Class<?> clazz, Object object) {
        return Strings.bracket(Classes.getShortName(clazz), object);
    }

    public static String range(Class<?> clazz, Object object, Object object2) {
        return Classes.getShortName(clazz) + '[' + object + " \u2026 " + object2 + ']';
    }

    public static String toUpperCase(String string, Characters.Filter filter, boolean bl) {
        int n;
        int n2 = string.length();
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                return string;
            }
            n = string.codePointAt(n3);
            if (!filter.contains(n) || n3 == 0 | bl && Character.toUpperCase(n) != n) break;
            n3 += Character.charCount(n);
        }
        StringBuilder stringBuilder = new StringBuilder(n2).append(string, 0, n3);
        while (n3 < n2) {
            n = string.codePointAt(n3);
            if (filter.contains(n)) {
                stringBuilder.appendCodePoint(n3 == 0 | bl ? Character.toUpperCase(n) : n);
            }
            n3 += Character.charCount(n);
        }
        return stringBuilder.toString();
    }

    public static void insertLineInLeftMargin(StringBuilder stringBuilder, String string) {
        int n = 9593;
        int n2 = CharSequences.skipTrailingWhitespaces(stringBuilder, 0, stringBuilder.length());
        while ((n2 = stringBuilder.lastIndexOf(string, n2 - 1)) >= 0) {
            stringBuilder.insert(n2 + string.length(), (char)n);
            n = 9475;
        }
    }

    public static String singleLine(String string, CharSequence charSequence) {
        if (charSequence != null) {
            CharSequence[] charSequenceArray = CharSequences.splitOnEOL(charSequence);
            int n = 0;
            for (int i = 0; i < charSequenceArray.length; ++i) {
                CharSequence charSequence2 = CharSequences.trimWhitespaces(charSequenceArray[i]);
                if (charSequence2.length() == 0) continue;
                charSequenceArray[n++] = charSequence2;
            }
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    return charSequenceArray[0].toString();
                }
                default: {
                    return String.join((CharSequence)string, ArraysExt.resize(charSequenceArray, n));
                }
            }
        }
        return null;
    }

    public static String toString(Class<?> clazz, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder(32).append(Classes.getShortName(clazz)).append('[');
        boolean bl = false;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            Object object2;
            if ((object2 = objectArray[++i]) == null) continue;
            if (bl) {
                stringBuilder.append(", ");
            }
            if ((object = objectArray[i - 1]) != null) {
                stringBuilder.append(object).append('=');
            }
            if (object2.getClass().isArray()) {
                int n = Array.getLength(object2);
                if (n != 1) {
                    stringBuilder.append('{');
                }
                for (int j = 0; j < n; ++j) {
                    if (j != 0) {
                        stringBuilder.append(", ");
                    }
                    Strings.append(Array.get(object2, j), stringBuilder);
                }
                if (n != 1) {
                    stringBuilder.append('}');
                }
            } else {
                Strings.append(object2, stringBuilder);
            }
            bl = true;
        }
        return stringBuilder.append(']').toString();
    }

    private static void append(Object object, StringBuilder stringBuilder) {
        boolean bl = object instanceof CharSequence;
        if (bl) {
            stringBuilder.append('\u201c');
        }
        stringBuilder.append(object);
        if (bl) {
            stringBuilder.append('\u201d');
        }
    }

    public static void formatTo(Formatter formatter, int n, int n2, int n3, String string) {
        Object[] objectArray;
        String string2;
        boolean bl;
        boolean bl2 = bl = (n & 2) != 0;
        if (bl && (n2 > 0 || n3 >= 0)) {
            string = string.toUpperCase(formatter.locale());
            bl = false;
        }
        int n4 = string.length();
        if (n3 >= 0) {
            int n5 = 0;
            for (int i = 0; i < n4; i += n5) {
                if (--n3 < 0) {
                    if (n5 == 0) {
                        string = "";
                        break;
                    }
                    n4 = (i -= n5) + 1;
                    StringBuilder stringBuilder = new StringBuilder(n4);
                    string = stringBuilder.append(string, 0, i).append('\u2026').toString();
                    break;
                }
                n5 = Character.charCount(string.codePointAt(i));
            }
        }
        if (n2 > n4 && (n2 -= string.codePointCount(0, n4)) > 0) {
            string2 = "%s%s";
            objectArray = new Object[]{string, string};
            objectArray[(n & 1) != 0 ? 1 : 0] = CharSequences.spaces(n2);
        } else {
            string2 = bl ? "%S" : "%s";
            objectArray = new Object[]{string};
        }
        formatter.format(string2, objectArray);
    }
}

