/*
 * Decompiled with CFR 0.152.
 */
package io.sf.jclf.text.format;

import io.sf.jclf.text.format.NumberFormat;
import io.sf.jclf.text.format.ObjectFormat;
import java.util.Random;

public class IntegerFormat
extends NumberFormat {
    public IntegerFormat() {
        this.precision = 1;
    }

    @Override
    public String format(Object o) {
        if (!(o instanceof Integer || o instanceof Long || o instanceof Short)) {
            throw new IllegalArgumentException("Object must be an Integer, Short or Long");
        }
        StringBuilder sb = new StringBuilder(14);
        String strVal = o.toString();
        if (this.precision != 0 || !strVal.equals("0")) {
            if (this.signpre && strVal.charAt(0) != '-') {
                this.rightAppend(sb, '+' + strVal, '0', this.precision, 0);
            } else {
                this.rightAppend(sb, strVal, '0', this.precision, 0);
            }
        }
        if (this.width > 0) {
            if (this.ralign) {
                char padchar = ' ';
                if (this.zeropadding) {
                    padchar = '0';
                }
                return ObjectFormat.rightJustify(sb.toString(), padchar, this.width, '%');
            }
            return ObjectFormat.leftJustify(sb.toString(), ' ', this.width, '%');
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.ralign) {
            sb.append('-');
        }
        if (this.width != 0) {
            sb.append(this.width);
        }
        if (this.precision > 0 && this.precision != this.width) {
            sb.append('.').append(this.precision);
        }
        sb.append('d');
        return sb.toString();
    }

    @Override
    public Object sample() {
        return new Random().nextInt();
    }
}

