/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import javax.swing.ImageIcon;
import org.openide.util.CachedHiDPIIcon;
import org.openide.util.Parameters;

final class ScaledBitmapIcon
extends CachedHiDPIIcon {
    private final Image sourceImage;
    private final int sourceWidth;
    private final int sourceHeight;

    public ScaledBitmapIcon(Image sourceImage, int width, int height) {
        super(width, height);
        Parameters.notNull((CharSequence)"sourceImage", (Object)sourceImage);
        this.sourceImage = sourceImage;
        ImageIcon imageIcon = new ImageIcon(sourceImage);
        this.sourceWidth = imageIcon.getIconWidth();
        this.sourceHeight = imageIcon.getIconHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Image createAndPaintImage(Component c, ColorModel colorModel, int deviceWidth, int deviceHeight, double scale) {
        BufferedImage img = ScaledBitmapIcon.createBufferedImage((ColorModel)colorModel, (int)deviceWidth, (int)deviceHeight);
        if (this.sourceWidth > 0 && this.sourceHeight > 0) {
            Graphics2D g = img.createGraphics();
            try {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g.setTransform(AffineTransform.getScaleInstance(scale * (double)this.getIconWidth() / (double)this.sourceWidth, scale * (double)this.getIconHeight() / (double)this.sourceHeight));
                g.drawImage(this.sourceImage, 0, 0, null);
            }
            finally {
                g.dispose();
            }
        }
        return img;
    }
}

