/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import writer2latex.office.ListStyle;
import writer2latex.util.Misc;

public class ListCounter {
    private int[] nCounter = new int[11];
    private String[] sNumFormat = new String[11];
    private int[] nStartValue = new int[11];
    private ListStyle style = null;
    private int nLevel = 1;

    public ListCounter() {
        for (int i = 1; i <= 10; ++i) {
            this.sNumFormat[i] = null;
        }
    }

    public ListCounter(ListStyle style) {
        this();
        if (style != null) {
            this.style = style;
            for (int i = 1; i <= 10; ++i) {
                this.sNumFormat[i] = style.getLevelProperty(i, "style:num-format");
                this.nStartValue[i] = Misc.getPosInteger(style.getLevelProperty(i, "text:start-value"), 1);
            }
        }
        this.restart(1);
    }

    public ListCounter step(int nLevel) {
        for (int i = 1; i < nLevel; ++i) {
            if (this.nCounter[i] != 0) continue;
            this.nCounter[i] = 1;
        }
        int n = nLevel;
        this.nCounter[n] = this.nCounter[n] + 1;
        if (nLevel < 10) {
            this.restart(nLevel + 1);
        }
        this.nLevel = nLevel;
        return this;
    }

    public ListCounter restart(int nLevel) {
        this.restart(nLevel, this.nStartValue[nLevel] - 1);
        return this;
    }

    public ListCounter restart(int nLevel, int nValue) {
        this.nCounter[nLevel] = nValue;
        for (int i = nLevel + 1; i <= 10; ++i) {
            this.nCounter[i] = 0;
        }
        return this;
    }

    public int getValue(int nLevel) {
        return this.nCounter[nLevel];
    }

    public int[] getValues() {
        int[] nCounterSnapshot = new int[11];
        System.arraycopy(this.nCounter, 0, nCounterSnapshot, 0, 11);
        return nCounterSnapshot;
    }

    public String getLabel() {
        return this.getPrefix() + this.getLabelAndSuffix();
    }

    public String getPrefix() {
        if (this.style.isNumber(this.nLevel)) {
            String sPrefix = this.style.getLevelProperty(this.nLevel, "style:num-prefix");
            return sPrefix != null ? sPrefix : "";
        }
        return "";
    }

    public String getLabelAndSuffix() {
        if (this.style.isNumber(this.nLevel)) {
            String sLabel = "";
            if (this.sNumFormat[this.nLevel] == null) {
                return "";
            }
            int nLevels = Misc.getPosInteger(this.style.getLevelProperty(this.nLevel, "text:display-levels"), 1);
            String sSuffix = this.style.getLevelProperty(this.nLevel, "style:num-suffix");
            String sSpace = "nothing".equals(this.style.getLevelStyleProperty(this.nLevel, "text:label-followed-by")) ? "" : " ";
            for (int j = this.nLevel - nLevels + 1; j < this.nLevel; ++j) {
                sLabel = sLabel + this.formatNumber(this.nCounter[j], this.sNumFormat[j], true) + ".";
            }
            sLabel = sLabel + this.formatNumber(this.nCounter[this.nLevel], this.sNumFormat[this.nLevel], true);
            if (sSuffix != null) {
                sLabel = sLabel + sSuffix;
            }
            if (sLabel.length() > 0 && sSpace != null) {
                sLabel = sLabel + sSpace;
            }
            return sLabel;
        }
        if (this.style.isBullet(this.nLevel)) {
            return this.style.getLevelProperty(this.nLevel, "text:bullet-char");
        }
        return "";
    }

    private String formatNumber(int number, String sStyle, boolean bLetterSync) {
        if ("a".equals(sStyle)) {
            return Misc.int2alph(number, bLetterSync);
        }
        if ("A".equals(sStyle)) {
            return Misc.int2Alph(number, bLetterSync);
        }
        if ("i".equals(sStyle)) {
            return Misc.int2roman(number);
        }
        if ("I".equals(sStyle)) {
            return Misc.int2Roman(number);
        }
        if ("1".equals(sStyle)) {
            return Misc.int2arabic(number);
        }
        return "";
    }
}

