/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.opensearch.ingest.UserAgentProperty;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class UserAgentProcessor
extends ProcessorBase
implements ProcessorVariant,
ToCopyableBuilder<Builder, UserAgentProcessor> {
    @Nonnull
    private final String field;
    @Nullable
    private final Boolean ignoreMissing;
    @Nonnull
    private final List<UserAgentProperty> options;
    @Nullable
    private final String regexFile;
    @Nullable
    private final String targetField;
    public static final JsonpDeserializer<UserAgentProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UserAgentProcessor::setupUserAgentProcessorDeserializer);

    private UserAgentProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreMissing = builder.ignoreMissing;
        this.options = ApiTypeHelper.unmodifiable(builder.options);
        this.regexFile = builder.regexFile;
        this.targetField = builder.targetField;
    }

    public static UserAgentProcessor of(Function<Builder, ObjectBuilder<UserAgentProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.UserAgent;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Nonnull
    public final List<UserAgentProperty> options() {
        return this.options;
    }

    @Nullable
    public final String regexFile() {
        return this.regexFile;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.options)) {
            generator.writeKey("options");
            generator.writeStartArray();
            for (UserAgentProperty item0 : this.options) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.regexFile != null) {
            generator.writeKey("regex_file");
            generator.write(this.regexFile);
        }
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupUserAgentProcessorDeserializer(ObjectDeserializer<Builder> op) {
        UserAgentProcessor.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::options, JsonpDeserializer.arrayDeserializer(UserAgentProperty._DESERIALIZER), "options");
        op.add(Builder::regexFile, JsonpDeserializer.stringDeserializer(), "regex_file");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.ignoreMissing);
        result = 31 * result + Objects.hashCode(this.options);
        result = 31 * result + Objects.hashCode(this.regexFile);
        result = 31 * result + Objects.hashCode(this.targetField);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAgentProcessor other = (UserAgentProcessor)o;
        return this.field.equals(other.field) && Objects.equals(this.ignoreMissing, other.ignoreMissing) && Objects.equals(this.options, other.options) && Objects.equals(this.regexFile, other.regexFile) && Objects.equals(this.targetField, other.targetField);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, UserAgentProcessor> {
        private String field;
        @Nullable
        private Boolean ignoreMissing;
        @Nullable
        private List<UserAgentProperty> options;
        @Nullable
        private String regexFile;
        @Nullable
        private String targetField;

        public Builder() {
        }

        private Builder(UserAgentProcessor o) {
            super(o);
            this.field = o.field;
            this.ignoreMissing = o.ignoreMissing;
            this.options = Builder._listCopy(o.options);
            this.regexFile = o.regexFile;
            this.targetField = o.targetField;
        }

        private Builder(Builder o) {
            super(o);
            this.field = o.field;
            this.ignoreMissing = o.ignoreMissing;
            this.options = Builder._listCopy(o.options);
            this.regexFile = o.regexFile;
            this.targetField = o.targetField;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        @Nonnull
        public final Builder options(List<UserAgentProperty> list) {
            this.options = Builder._listAddAll(this.options, list);
            return this;
        }

        @Nonnull
        public final Builder options(UserAgentProperty value, UserAgentProperty ... values) {
            this.options = Builder._listAdd(this.options, value, values);
            return this;
        }

        @Nonnull
        public final Builder regexFile(@Nullable String value) {
            this.regexFile = value;
            return this;
        }

        @Nonnull
        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        @Override
        @Nonnull
        public UserAgentProcessor build() {
            this._checkSingleUse();
            return new UserAgentProcessor(this);
        }
    }
}

