/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.com.amazonaws.transform;

import org.opensearch.notifications.core.repackage.com.amazonaws.AmazonServiceException;
import org.opensearch.notifications.core.repackage.com.amazonaws.annotation.SdkInternalApi;
import org.opensearch.notifications.core.repackage.com.amazonaws.annotation.ThreadSafe;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.AbstractErrorUnmarshaller;
import org.opensearch.notifications.core.repackage.com.amazonaws.util.PropertyNamingStrategyUtils;
import org.opensearch.notifications.core.repackage.com.fasterxml.jackson.core.TreeNode;
import org.opensearch.notifications.core.repackage.com.fasterxml.jackson.databind.DeserializationFeature;
import org.opensearch.notifications.core.repackage.com.fasterxml.jackson.databind.JsonNode;
import org.opensearch.notifications.core.repackage.com.fasterxml.jackson.databind.ObjectMapper;
import org.opensearch.notifications.core.repackage.com.fasterxml.jackson.databind.node.NullNode;

@SdkInternalApi
@ThreadSafe
public class JsonErrorUnmarshaller
extends AbstractErrorUnmarshaller<JsonNode> {
    public static final JsonErrorUnmarshaller DEFAULT_UNMARSHALLER = new JsonErrorUnmarshaller(AmazonServiceException.class, null);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final String handledErrorCode;

    public JsonErrorUnmarshaller(Class<? extends AmazonServiceException> exceptionClass, String handledErrorCode) {
        super(exceptionClass);
        this.handledErrorCode = handledErrorCode;
    }

    @Override
    public AmazonServiceException unmarshall(JsonNode jsonContent) throws Exception {
        if (jsonContent == null || NullNode.instance.equals((Object)jsonContent)) {
            return null;
        }
        return (AmazonServiceException)MAPPER.treeToValue((TreeNode)jsonContent, this.exceptionClass);
    }

    public boolean matchErrorCode(String actualErrorCode) {
        if (this.handledErrorCode == null) {
            return true;
        }
        return this.handledErrorCode.equals(actualErrorCode);
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        PropertyNamingStrategyUtils.configureUpperCamelCase(MAPPER);
    }
}

