/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiedInitializableComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.saml.common.binding.EndpointResolver;
import org.opensaml.saml.criterion.BestMatchLocationCriterion;
import org.opensaml.saml.criterion.BindingCriterion;
import org.opensaml.saml.criterion.EndpointCriterion;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.IndexedEndpoint;
import org.slf4j.Logger;

public abstract class AbstractEndpointResolver<EndpointType extends Endpoint>
extends AbstractIdentifiedInitializableComponent
implements EndpointResolver<EndpointType> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractEndpointResolver.class);
    private boolean inMetadataOrder;

    public AbstractEndpointResolver() {
        super.setId(this.getClass().getName());
        this.inMetadataOrder = true;
    }

    public boolean isInMetadataOrder() {
        return this.inMetadataOrder;
    }

    public void setInMetadataOrder(boolean flag) {
        this.checkSetterPreconditions();
        this.inMetadataOrder = flag;
    }

    @Override
    @Nonnull
    public Iterable<EndpointType> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        EndpointCriterion<EndpointType> endpointCriterion = this.validateCriteria(criteria);
        assert (criteria != null);
        if (this.canUseRequestedEndpoint(endpointCriterion)) {
            EndpointType endpoint = endpointCriterion.getEndpoint();
            if (this.doCheckEndpoint(criteria, endpoint)) {
                return CollectionSupport.singletonList(endpoint);
            }
            this.log.debug("{} Requested endpoint was rejected by extended validation process", (Object)this.getLogPrefix());
            return CollectionSupport.emptyList();
        }
        List<EndpointType> candidates = this.getCandidatesFromMetadata(criteria);
        Iterator<EndpointType> i = candidates.iterator();
        while (i.hasNext()) {
            if (this.doCheckEndpoint(criteria, (Endpoint)i.next())) continue;
            i.remove();
        }
        this.log.debug("{} {} endpoints remain after filtering process", (Object)this.getLogPrefix(), (Object)candidates.size());
        return candidates;
    }

    @Override
    @Nullable
    public EndpointType resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        EndpointCriterion<EndpointType> endpointCriterion = this.validateCriteria(criteria);
        assert (criteria != null);
        if (this.canUseRequestedEndpoint(endpointCriterion)) {
            EndpointType endpoint = endpointCriterion.getEndpoint();
            if (this.doCheckEndpoint(criteria, endpoint)) {
                return endpoint;
            }
            this.log.debug("{} Requested endpoint was rejected by extended validation process", (Object)this.getLogPrefix());
            return null;
        }
        int bestMatchLen = -1;
        Endpoint bestMatch = null;
        BestMatchLocationCriterion startsWith = criteria.get(BestMatchLocationCriterion.class);
        for (Endpoint candidate : this.getCandidatesFromMetadata(criteria)) {
            assert (candidate != null);
            if (!this.doCheckEndpoint(criteria, candidate)) continue;
            if (startsWith != null) {
                int i;
                String candidateLocation = candidate.getLocation();
                if (candidateLocation == null) {
                    candidateLocation = candidate.getResponseLocation();
                }
                if (candidateLocation == null) {
                    this.log.debug("Skipping endpoint with no Location or ResponseLocation");
                    continue;
                }
                for (i = 0; i < candidateLocation.length() && i < startsWith.getLocation().length() && candidateLocation.charAt(i) == startsWith.getLocation().charAt(i); ++i) {
                }
                if (i <= bestMatchLen) continue;
                bestMatchLen = i;
                bestMatch = candidate;
                continue;
            }
            return (EndpointType)candidate;
        }
        if (bestMatch != null) {
            return (EndpointType)bestMatch;
        }
        this.log.debug("{} No candidate endpoints met criteria", (Object)this.getLogPrefix());
        return null;
    }

    protected boolean doCheckEndpoint(@Nonnull CriteriaSet criteria, @Nonnull EndpointType endpoint) {
        return true;
    }

    @Nonnull
    private EndpointCriterion<EndpointType> validateCriteria(@Nullable CriteriaSet criteria) throws ResolverException {
        if (criteria == null) {
            throw new ResolverException("CriteriaSet cannot be null");
        }
        EndpointCriterion epCriterion = criteria.get(EndpointCriterion.class);
        if (epCriterion == null) {
            throw new ResolverException("EndpointCriterion not supplied");
        }
        return epCriterion;
    }

    private boolean canUseRequestedEndpoint(@Nonnull EndpointCriterion<EndpointType> criterion) {
        EndpointType requestedEndpoint;
        return criterion.isTrusted() && (requestedEndpoint = criterion.getEndpoint()).getBinding() != null && (requestedEndpoint.getLocation() != null || requestedEndpoint.getResponseLocation() != null);
    }

    @Nonnull
    private List<EndpointType> getCandidatesFromMetadata(@Nonnull CriteriaSet criteria) {
        List<Endpoint> endpoints;
        RoleDescriptorCriterion role = criteria.get(RoleDescriptorCriterion.class);
        if (role == null) {
            this.log.debug("{} No metadata supplied, no candidate endpoints to return", (Object)this.getLogPrefix());
            return new ArrayList();
        }
        EndpointCriterion epCriterion = criteria.get(EndpointCriterion.class);
        assert (epCriterion != null);
        QName endpointType = epCriterion.getEndpoint().getSchemaType();
        if (endpointType == null) {
            endpointType = epCriterion.getEndpoint().getElementQName();
        }
        if ((endpoints = role.getRole().getEndpoints(endpointType)).isEmpty()) {
            this.log.debug("{} No endpoints in metadata of type {}", (Object)this.getLogPrefix(), (Object)endpointType);
            return new ArrayList();
        }
        BindingCriterion bindingCriterion = criteria.get(BindingCriterion.class);
        if (this.inMetadataOrder || bindingCriterion == null || bindingCriterion.getBindings().isEmpty()) {
            this.log.debug("{} Returning {} candidate endpoints of type {}", new Object[]{this.getLogPrefix(), endpoints.size(), endpointType});
            return this.sortCandidates(endpoints);
        }
        ArrayList<EndpointType> sortedResults = new ArrayList<EndpointType>(endpoints.size());
        for (String binding : bindingCriterion.getBindings()) {
            sortedResults.addAll(this.sortCandidates(endpoints.stream().filter(ep -> binding.equals(ep.getBinding())).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList())).get()));
        }
        this.log.debug("{} Returning {} candidate endpoints of type {}", new Object[]{this.getLogPrefix(), sortedResults.size(), endpointType});
        return sortedResults;
    }

    @Nonnull
    private List<EndpointType> sortCandidates(@Nonnull List<Endpoint> candidates) {
        Endpoint hardDefault = null;
        Endpoint softDefault = null;
        LinkedList<Endpoint> toReturn = new LinkedList<Endpoint>();
        for (Endpoint endpoint : candidates) {
            if (hardDefault == null && endpoint instanceof IndexedEndpoint) {
                IndexedEndpoint indexed = (IndexedEndpoint)endpoint;
                Boolean flag = indexed.isDefault();
                if (flag != null) {
                    if (flag.booleanValue()) {
                        hardDefault = endpoint;
                        if (softDefault == null) continue;
                        toReturn.addFirst(softDefault);
                        softDefault = null;
                        continue;
                    }
                    toReturn.addLast(endpoint);
                    continue;
                }
                if (hardDefault == null && softDefault == null) {
                    softDefault = endpoint;
                    continue;
                }
                toReturn.addLast(endpoint);
                continue;
            }
            toReturn.addLast(endpoint);
        }
        if (hardDefault != null) {
            toReturn.addFirst(hardDefault);
        } else if (softDefault != null) {
            toReturn.addFirst(softDefault);
        }
        return toReturn;
    }

    @Nonnull
    protected String getLogPrefix() {
        return "Endpoint Resolver " + this.getId() + ":";
    }
}

