/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.conf;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.protege.editor.owl.model.util.OboUtilities;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.SKOSVocabulary;

public class IRIExpander {
    private static Map<String, IRI> builtInVocabulary = new HashMap<String, IRI>();

    public static Optional<IRI> expand(@Nullable String iri) {
        if (iri == null) {
            return Optional.empty();
        }
        if (OboUtilities.isOboId(iri)) {
            return Optional.of(OboUtilities.getOboLibraryIriFromOboId(iri));
        }
        IRI builtInIri = builtInVocabulary.get(iri);
        if (builtInIri != null) {
            return Optional.of(builtInIri);
        }
        return Optional.of(IRI.create((String)iri));
    }

    static {
        for (OWLRDFVocabulary oWLRDFVocabulary : OWLRDFVocabulary.values()) {
            builtInVocabulary.put(oWLRDFVocabulary.getPrefixedName(), oWLRDFVocabulary.getIRI());
        }
        for (OWLRDFVocabulary oWLRDFVocabulary : SKOSVocabulary.values()) {
            builtInVocabulary.put(oWLRDFVocabulary.getPrefixedName(), oWLRDFVocabulary.getIRI());
        }
    }
}

