/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;

public class OWLCellRendererSimple
implements TreeCellRenderer,
ListCellRenderer {
    private OWLEditorKit owlEditorKit;
    private DefaultTreeCellRenderer treeCellRendererDelegate;
    private DefaultListCellRenderer listCellRenderDelegate;
    private boolean displayQuotes = true;

    public OWLCellRendererSimple(OWLEditorKit owlEditorKit) {
        this.owlEditorKit = owlEditorKit;
        this.treeCellRendererDelegate = new DefaultTreeCellRenderer();
        this.listCellRenderDelegate = new DefaultListCellRenderer();
    }

    public void setDisplayQuotes(boolean displayQuotes) {
        this.displayQuotes = displayQuotes;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel label = (JLabel)this.treeCellRendererDelegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        this.prepareRenderer(label, value);
        return label;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)this.listCellRenderDelegate.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        this.prepareRenderer(label, value);
        return label;
    }

    private void prepareRenderer(JLabel label, Object value) {
        Font font = OWLRendererPreferences.getInstance().getFont();
        label.setFont(font);
        this.setText(value, label);
        this.setIcon(value, label);
        this.boldIfNecessary(value, label);
        if (value == null) {
            label.setPreferredSize(new Dimension(label.getPreferredSize().width, label.getFontMetrics(font).getHeight()));
        }
    }

    private void setText(Object value, JLabel renderer) {
        if (value instanceof OWLObject) {
            OWLObject obj = (OWLObject)value;
            String rendering = this.owlEditorKit.getModelManager().getRendering(obj);
            if (!this.displayQuotes && rendering.length() > 2 && rendering.startsWith("'") && rendering.endsWith("'")) {
                String stripped = rendering.substring(1, rendering.length() - 1);
                renderer.setText(stripped);
            } else {
                renderer.setText(rendering);
            }
        }
    }

    private void setIcon(Object value, JLabel renderer) {
        if (value instanceof OWLObject) {
            OWLObject obj = (OWLObject)value;
            Icon icon = this.owlEditorKit.getWorkspace().getOWLIconProvider().getIcon(obj);
            renderer.setIcon(icon);
        }
    }

    private void boldIfNecessary(Object value, JLabel renderer) {
        if (value instanceof OWLEntity) {
            OWLEntity ent = (OWLEntity)value;
            if (ent instanceof OWLClass) {
                if (!this.owlEditorKit.getModelManager().getActiveOntology().getAxioms((OWLClass)ent).isEmpty()) {
                    OWLCellRendererSimple.makeBold(renderer);
                }
            } else if (ent instanceof OWLObjectProperty) {
                if (!this.owlEditorKit.getModelManager().getActiveOntology().getAxioms((OWLObjectPropertyExpression)((OWLObjectProperty)ent)).isEmpty()) {
                    OWLCellRendererSimple.makeBold(renderer);
                }
            } else if (ent instanceof OWLDataProperty) {
                if (!this.owlEditorKit.getModelManager().getActiveOntology().getAxioms((OWLDataProperty)ent).isEmpty()) {
                    OWLCellRendererSimple.makeBold(renderer);
                }
            } else if (ent instanceof OWLIndividual && !this.owlEditorKit.getModelManager().getActiveOntology().getAxioms((OWLIndividual)ent).isEmpty()) {
                OWLCellRendererSimple.makeBold(renderer);
            }
        }
    }

    private static void makeBold(JLabel label) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body><b>");
        sb.append(label.getText());
        sb.append("</b></body></html>");
        label.setText(sb.toString());
    }
}

