/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.ast.PyAstStatementListContainer;
import com.jetbrains.python.ast.impl.PyUtilCore;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotationOwner;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypeDeclarationStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyNoneTypeKt;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParameterType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.PyUnsafeUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.PyPsiRefactoringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyTypeHintGenerationUtil {
    public static final String TYPE_COMMENT_PREFIX = "# type: ";

    private PyTypeHintGenerationUtil() {
    }

    public static void insertStandaloneAttributeTypeComment(@NotNull PyTargetExpression target, AnnotationInfo info, boolean startTemplate) {
        PyClass pyClass;
        if (target == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(0);
        }
        if ((pyClass = target.getContainingClass()) == null) {
            throw new IllegalArgumentException("Target '" + target.getText() + "' in not contained in a class definition");
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)target)) {
            return;
        }
        PyElementGenerator generator = PyElementGenerator.getInstance((Project)target.getProject());
        LanguageLevel langLevel = LanguageLevel.forElement((PsiElement)target);
        String assignedValue = langLevel.isPython2() ? "None" : "...";
        String declarationText = target.getName() + " = " + assignedValue + " # type: " + info.getAnnotationText();
        PyAssignmentStatement declaration = (PyAssignmentStatement)generator.createFromText(langLevel, PyAssignmentStatement.class, declarationText);
        PsiElement anchorBefore = PyTypeHintGenerationUtil.findPrecedingAnchorForAttributeDeclaration(pyClass);
        WriteAction.run(() -> {
            PyAssignmentStatement inserted = (PyAssignmentStatement)pyClass.getStatementList().addAfter((PsiElement)declaration, anchorBefore);
            PsiComment insertedComment = PyUtil.as(inserted.getLastChild(), PsiComment.class);
            if (insertedComment == null) {
                return;
            }
            PyTypeHintGenerationUtil.addImportsForTypeAnnotations(info.getFullyQualifiedTypeHints(), (PsiElement)target);
            insertedComment = (PsiComment)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)insertedComment);
            if (startTemplate && insertedComment != null) {
                PyTypeHintGenerationUtil.openEditorAndAddTemplateForTypeComment(insertedComment, info.getAnnotationText(), info.getTypeRanges());
            }
        });
    }

    public static void insertStandaloneAttributeAnnotation(@NotNull PyTargetExpression target, @NotNull AnnotationInfo info, boolean startTemplate) {
        LanguageLevel langLevel;
        if (target == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(1);
        }
        if (info == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(2);
        }
        if ((langLevel = LanguageLevel.forElement((PsiElement)target)).isOlderThan(LanguageLevel.PYTHON36)) {
            throw new IllegalArgumentException("Target '" + target.getText() + "' doesn't belong to Python 3.6+ project: " + String.valueOf(langLevel));
        }
        PyClass pyClass = target.getContainingClass();
        if (pyClass == null) {
            throw new IllegalArgumentException("Target '" + target.getText() + "' in not contained in a class definition");
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)target)) {
            return;
        }
        PyElementGenerator generator = PyElementGenerator.getInstance((Project)target.getProject());
        String declarationText = target.getName() + ": " + info.getAnnotationText();
        PyTypeDeclarationStatement declaration = (PyTypeDeclarationStatement)generator.createFromText(langLevel, PyTypeDeclarationStatement.class, declarationText);
        PsiElement anchorBefore = PyTypeHintGenerationUtil.findPrecedingAnchorForAttributeDeclaration(pyClass);
        WriteAction.run(() -> {
            PyTypeDeclarationStatement inserted = (PyTypeDeclarationStatement)pyClass.getStatementList().addAfter((PsiElement)declaration, anchorBefore);
            PyTypeHintGenerationUtil.addImportsForTypeAnnotations(info.getFullyQualifiedTypeHints(), (PsiElement)target);
            inserted = (PyTypeDeclarationStatement)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)inserted);
            if (startTemplate && inserted != null) {
                PyTypeHintGenerationUtil.openEditorAndAddTemplateForAnnotation((PyAnnotationOwner)inserted);
            }
        });
    }

    @Nullable
    private static PsiElement findPrecedingAnchorForAttributeDeclaration(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(3);
        }
        PyStatement firstStatement = pyClass.getStatementList().getStatements()[0];
        PyStringLiteralExpression classDocstring = pyClass.getDocStringExpression();
        if (firstStatement instanceof PyExpressionStatement && classDocstring == ((PyExpressionStatement)firstStatement).getExpression()) {
            return firstStatement;
        }
        return null;
    }

    public static void insertVariableAnnotation(@NotNull PyTargetExpression target, @Nullable TypeEvalContext context, @NotNull AnnotationInfo info, boolean startTemplate) {
        ThrowableComputable addOrUpdateAnnotatedStatement;
        LanguageLevel langLevel;
        if (target == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(4);
        }
        if (info == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(5);
        }
        if ((langLevel = LanguageLevel.forElement((PsiElement)target)).isOlderThan(LanguageLevel.PYTHON36)) {
            throw new IllegalArgumentException("Target '" + target.getText() + "' doesn't belong to Python 3.6+ project: " + String.valueOf(langLevel));
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)target)) {
            return;
        }
        Project project = target.getProject();
        if (PyTypeHintGenerationUtil.canUseInlineAnnotation(target)) {
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)project);
            PyAssignmentStatement assignment = (PyAssignmentStatement)target.getParent();
            SmartPsiElementPointer pointer = manager.createSmartPsiElementPointer((PsiElement)assignment);
            addOrUpdateAnnotatedStatement = () -> {
                PyUtil.updateDocumentUnblockedAndCommitted((PsiElement)target, (Consumer<? super Document>)((Consumer)document -> document.insertString(target.getTextRange().getEndOffset(), (CharSequence)(": " + info.getAnnotationText()))));
                return (PyAnnotationOwner)pointer.getElement();
            };
        } else {
            PyElementGenerator generator = PyElementGenerator.getInstance((Project)project);
            String declarationText = target.getName() + ": " + info.getAnnotationText();
            PyTypeDeclarationStatement declaration = (PyTypeDeclarationStatement)generator.createFromText(langLevel, PyTypeDeclarationStatement.class, declarationText);
            PyStatement statement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)target, PyStatement.class);
            assert (statement != null);
            addOrUpdateAnnotatedStatement = () -> (PyAnnotationOwner)statement.getParent().addBefore((PsiElement)declaration, (PsiElement)statement);
        }
        WriteAction.run(() -> {
            PyAnnotationOwner createdAnnotationOwner = (PyAnnotationOwner)addOrUpdateAnnotatedStatement.compute();
            if (createdAnnotationOwner == null) {
                return;
            }
            if (context != null) {
                PyTypeHintGenerationUtil.addImportsForTypeAnnotations(info.getFullyQualifiedTypeHints(), (PsiElement)target);
            }
            createdAnnotationOwner = (PyAnnotationOwner)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)createdAnnotationOwner);
            if (startTemplate && createdAnnotationOwner != null) {
                PyTypeHintGenerationUtil.openEditorAndAddTemplateForAnnotation(createdAnnotationOwner);
            }
        });
    }

    private static void openEditorAndAddTemplateForAnnotation(@NotNull PyAnnotationOwner annotated) {
        if (annotated == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(6);
        }
        assert (annotated.isValid());
        assert (annotated.getAnnotationValue() != null);
        Project project = annotated.getProject();
        int initialCaretOffset = annotated.getTextRange().getStartOffset();
        VirtualFile updatedVirtualFile = annotated.getContainingFile().getVirtualFile();
        TemplateBuilder templateBuilder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)annotated);
        String annotation = annotated.getAnnotationValue();
        Object replacementText = ApplicationManager.getApplication().isUnitTestMode() ? "[" + annotation + "]" : annotation;
        templateBuilder.replaceElement((PsiElement)annotated.getAnnotation().getValue(), (String)replacementText);
        Editor editor = PythonUiService.getInstance().openTextEditor(project, updatedVirtualFile, initialCaretOffset);
        if (editor != null) {
            editor.getCaretModel().moveToOffset(initialCaretOffset);
            templateBuilder.run(editor, true);
        } else {
            templateBuilder.runNonInteractively(true);
        }
    }

    private static boolean canUseInlineAnnotation(@NotNull PyTargetExpression target) {
        PyAssignmentStatement assignment;
        if (target == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(7);
        }
        return (assignment = PyUtil.as(target.getParent(), PyAssignmentStatement.class)) != null && assignment.getRawTargets().length == 1 && assignment.getLeftHandSideExpression() == target;
    }

    public static void insertVariableTypeComment(@NotNull PyTargetExpression target, @NotNull AnnotationInfo info, boolean startTemplate) {
        ThrowableRunnable insertComment;
        PsiElement insertionAnchor;
        if (target == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(8);
        }
        if (info == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(9);
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)target)) {
            return;
        }
        String typeCommentText = "  # type: " + info.getAnnotationText();
        PyStatement statement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)target, PyStatement.class);
        if (statement instanceof PyAssignmentStatement) {
            insertionAnchor = statement.getLastChild();
        } else if (statement instanceof PyWithStatement) {
            insertionAnchor = PyUtilCore.getHeaderEndAnchor((PyAstStatementListContainer)((PyStatementListContainer)statement));
        } else if (statement instanceof PyForStatement) {
            insertionAnchor = PyUtilCore.getHeaderEndAnchor((PyAstStatementListContainer)((PyForStatement)statement).getForPart());
        } else {
            throw new IllegalArgumentException("Target expression must belong to an assignment, \"with\" statement or \"for\" loop");
        }
        if (insertionAnchor instanceof PsiComment) {
            String combinedTypeCommentText = typeCommentText + " " + insertionAnchor.getText();
            PsiElement lastNonComment = PyPsiUtils.getPrevNonCommentSibling((PsiElement)insertionAnchor, (boolean)true);
            int startOffset = lastNonComment.getTextRange().getEndOffset();
            int endOffset = insertionAnchor.getTextRange().getEndOffset();
            insertComment = () -> PyUtil.updateDocumentUnblockedAndCommitted((PsiElement)target, (Consumer<? super Document>)((Consumer)document -> document.replaceString(startOffset, endOffset, (CharSequence)combinedTypeCommentText)));
        } else if (insertionAnchor != null) {
            int offset = insertionAnchor.getTextRange().getEndOffset();
            insertComment = () -> PyUtil.updateDocumentUnblockedAndCommitted((PsiElement)target, (Consumer<? super Document>)((Consumer)document -> document.insertString(offset, (CharSequence)typeCommentText)));
        } else {
            return;
        }
        WriteAction.run(() -> {
            insertComment.run();
            PsiComment insertedComment = target.getTypeComment();
            if (insertedComment == null) {
                return;
            }
            PyTypeHintGenerationUtil.addImportsForTypeAnnotations(info.getFullyQualifiedTypeHints(), (PsiElement)target);
            insertedComment = (PsiComment)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)insertedComment);
            if (startTemplate && insertedComment != null) {
                PyTypeHintGenerationUtil.openEditorAndAddTemplateForTypeComment(insertedComment, info.getAnnotationText(), info.getTypeRanges());
            }
        });
    }

    private static void openEditorAndAddTemplateForTypeComment(@NotNull PsiComment insertedComment, @NotNull String annotation, @NotNull List<TextRange> typeRanges) {
        if (insertedComment == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(10);
        }
        if (annotation == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(11);
        }
        if (typeRanges == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(12);
        }
        int initialCaretOffset = insertedComment.getTextRange().getStartOffset();
        VirtualFile updatedVirtualFile = insertedComment.getContainingFile().getVirtualFile();
        Project project = insertedComment.getProject();
        TemplateBuilder templateBuilder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)insertedComment);
        boolean testMode = ApplicationManager.getApplication().isUnitTestMode();
        for (TextRange range : typeRanges) {
            String individualType = range.substring(annotation);
            Object replacementText = testMode ? "[" + individualType + "]" : individualType;
            templateBuilder.replaceRange(range.shiftRight(TYPE_COMMENT_PREFIX.length()), (String)replacementText);
        }
        Editor editor = PythonUiService.getInstance().openTextEditor(project, updatedVirtualFile, initialCaretOffset);
        if (editor != null) {
            editor.getCaretModel().moveToOffset(initialCaretOffset);
            templateBuilder.run(editor, true);
        } else {
            templateBuilder.runNonInteractively(true);
        }
    }

    public static void addImportsForTypeAnnotations(@NotNull Collection<String> types, @NotNull PsiElement anchor) {
        if (types == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(13);
        }
        if (anchor == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(14);
        }
        TreeSet<PsiNamedElement> symbols = new TreeSet<PsiNamedElement>(Comparator.comparing(PsiNamedElement::getName, Comparator.nullsFirst(Comparator.naturalOrder())));
        for (String type : types) {
            PyTypeHintGenerationUtil.collectImportTargetsFromTypeExpression(type, anchor, symbols);
        }
        PsiFile file = anchor.getContainingFile();
        for (PsiNamedElement symbol : symbols) {
            PyPsiRefactoringUtil.insertImport((PsiElement)file, symbol, null, true);
        }
    }

    private static void collectImportTargetsFromTypeExpression(@NotNull String typeExpressionText, @NotNull PsiElement anchor, final @NotNull @NotNull Set<@NotNull PsiNamedElement> symbols) {
        if (typeExpressionText == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(15);
        }
        if (anchor == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(16);
        }
        if (symbols == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(17);
        }
        PyExpression typeExpression = PyUtil.createExpressionFromFragment(typeExpressionText, anchor);
        assert (typeExpression != null);
        final PyQualifiedNameResolveContext qNameResolveContext = PyResolveImportUtil.fromFoothold(anchor);
        typeExpression.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

            public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
                PsiElement element;
                QualifiedName qualifiedName;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (node.isQualified() && (qualifiedName = node.asQualifiedName()) != null && (element = PyResolveImportUtil.resolveTopLevelMember(qualifiedName, qNameResolveContext)) instanceof PsiNamedElement) {
                    PsiNamedElement namedElement = (PsiNamedElement)element;
                    symbols.add(namedElement);
                    return;
                }
                super.visitPyReferenceExpression(node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/codeInsight/intentions/PyTypeHintGenerationUtil$1", "visitPyReferenceExpression"));
            }
        });
    }

    public static void checkPep484Compatibility(@Nullable PyType type, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeHintGenerationUtil.$$$reportNull$$$0(18);
        }
        if (type == null || PyNoneTypeKt.isNoneType(type) || type instanceof PyUnsafeUnionType || type instanceof PyTypeParameterType) {
            return;
        }
        if (type instanceof PyUnionType) {
            PyUnionType unionType = (PyUnionType)type;
            for (PyType memberType : unionType.getMembers()) {
                PyTypeHintGenerationUtil.checkPep484Compatibility(memberType, context);
            }
        } else if (type instanceof PyCollectionType) {
            for (PyType typeParam : ((PyCollectionType)type).getElementTypes()) {
                PyTypeHintGenerationUtil.checkPep484Compatibility(typeParam, context);
            }
        } else if (!(type instanceof PyClassType)) {
            if (type instanceof PyCallableType) {
                PyCallableType callableType = (PyCallableType)type;
                for (PyCallableParameter parameter : ContainerUtil.notNullize((List)callableType.getParameters(context))) {
                    PyTypeHintGenerationUtil.checkPep484Compatibility(parameter.getType(context), context);
                }
                PyTypeHintGenerationUtil.checkPep484Compatibility(callableType.getReturnType(context), context);
            } else {
                throw new Pep484IncompatibleTypeException(PyPsiBundle.message("INTN.add.type.hint.for.variable.PEP484.incompatible.type", type.getName()));
            }
        }
    }

    public static boolean isTypeHintComment(PsiElement element) {
        return element instanceof PsiComment && element.getText().startsWith(TYPE_COMMENT_PREFIX);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotated";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertedComment";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeRanges";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeExpressionText";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbols";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyTypeHintGenerationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "insertStandaloneAttributeTypeComment";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "insertStandaloneAttributeAnnotation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findPrecedingAnchorForAttributeDeclaration";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "insertVariableAnnotation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "openEditorAndAddTemplateForAnnotation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "canUseInlineAnnotation";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "insertVariableTypeComment";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "openEditorAndAddTemplateForTypeComment";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "addImportsForTypeAnnotations";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "collectImportTargetsFromTypeExpression";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPep484Compatibility";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class AnnotationInfo {
        private final String myAnnotationText;
        private final List<String> myFullyQualifiedTypeHints;
        private final List<TextRange> myTypeRanges;

        public AnnotationInfo(@NotNull String annotationText) {
            if (annotationText == null) {
                AnnotationInfo.$$$reportNull$$$0(0);
            }
            this(annotationText, Collections.emptyList(), Collections.singletonList(TextRange.allOf((String)annotationText)));
        }

        public AnnotationInfo(@NotNull String annotationText, @NotNull String fullyQualifiedTypeHint) {
            if (annotationText == null) {
                AnnotationInfo.$$$reportNull$$$0(1);
            }
            if (fullyQualifiedTypeHint == null) {
                AnnotationInfo.$$$reportNull$$$0(2);
            }
            this(annotationText, Collections.singletonList(fullyQualifiedTypeHint), Collections.singletonList(TextRange.allOf((String)annotationText)));
        }

        public AnnotationInfo(@NotNull String annotationText, @NotNull List<String> fullyQualifiedTypeHints, @NotNull List<TextRange> typeRanges) {
            if (annotationText == null) {
                AnnotationInfo.$$$reportNull$$$0(3);
            }
            if (fullyQualifiedTypeHints == null) {
                AnnotationInfo.$$$reportNull$$$0(4);
            }
            if (typeRanges == null) {
                AnnotationInfo.$$$reportNull$$$0(5);
            }
            this.myAnnotationText = annotationText;
            this.myFullyQualifiedTypeHints = fullyQualifiedTypeHints;
            this.myTypeRanges = typeRanges;
        }

        @NotNull
        public String getAnnotationText() {
            String string = this.myAnnotationText;
            if (string == null) {
                AnnotationInfo.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public List<String> getFullyQualifiedTypeHints() {
            List<String> list = this.myFullyQualifiedTypeHints;
            if (list == null) {
                AnnotationInfo.$$$reportNull$$$0(7);
            }
            return list;
        }

        @NotNull
        public List<TextRange> getTypeRanges() {
            List<TextRange> list = this.myTypeRanges;
            if (list == null) {
                AnnotationInfo.$$$reportNull$$$0(8);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotationText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fullyQualifiedTypeHint";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fullyQualifiedTypeHints";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeRanges";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyTypeHintGenerationUtil$AnnotationInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyTypeHintGenerationUtil$AnnotationInfo";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotationText";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullyQualifiedTypeHints";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeRanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7, 8 -> new IllegalStateException(string);
            };
        }
    }

    public static final class Pep484IncompatibleTypeException
    extends RuntimeException {
        public Pep484IncompatibleTypeException(String message) {
            super(message);
        }
    }
}

