/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.HierarchicalColumnsDataGridModel;
import com.intellij.database.datagrid.NestedTable;
import com.intellij.database.extractors.BaseObjectFormatter;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.ImageInfo;
import com.intellij.database.extractors.JsonUtilKt;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.run.ui.grid.editors.FormatsCache;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NestedTableAwareObjectFormatter
extends BaseObjectFormatter {
    public NestedTableAwareObjectFormatter() {
        this(new FormatsCache(), new FormatterCreator());
    }

    public NestedTableAwareObjectFormatter(@NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator) {
        if (formatsCache == null) {
            NestedTableAwareObjectFormatter.$$$reportNull$$$0(0);
        }
        if (formatterCreator == null) {
            NestedTableAwareObjectFormatter.$$$reportNull$$$0(1);
        }
        super(formatsCache, formatterCreator);
        this.myToString.register(NestedTable.class, new BaseObjectFormatter.Converter<NestedTable, String>(){

            @Override
            public String convert(NestedTable o, GridColumn column, ObjectFormatterConfig config) {
                ObjectFormatterMode itemsMode = config.getMode() == ObjectFormatterMode.SQL_SCRIPT ? ObjectFormatterMode.SQL_SCRIPT : ObjectFormatterMode.JSON;
                return JsonUtilKt.toJson(o, NestedTableAwareObjectFormatter.this, itemsMode, false, true, false);
            }
        });
        this.myToString.register(ImageInfo.class, new BaseObjectFormatter.Converter<ImageInfo, String>(this){

            @Override
            public String convert(ImageInfo o, GridColumn column, ObjectFormatterConfig config) {
                if (config.getMode() == ObjectFormatterMode.DISPLAY || o.bytes == null) {
                    return o.width + "x" + o.height + " " + StringUtil.toUpperCase((String)o.format) + " image " + StringUtil.formatFileSize((long)o.size);
                }
                return o.toString();
            }
        });
    }

    @Override
    public boolean isStringLiteral(@Nullable GridColumn column, @Nullable Object value, @NotNull ObjectFormatterMode mode) {
        if (mode == null) {
            NestedTableAwareObjectFormatter.$$$reportNull$$$0(2);
        }
        if (mode == ObjectFormatterMode.JSON) {
            return !(value instanceof Number) && !(value instanceof Boolean) && !(value instanceof Map) && !(value instanceof List);
        }
        if (mode == ObjectFormatterMode.SQL_SCRIPT) {
            if (value instanceof NestedTable) {
                return true;
            }
            if (value instanceof Map && column instanceof HierarchicalColumnsDataGridModel.ExtractorHierarchicalGridColumn) {
                return true;
            }
        }
        return value instanceof String;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatsCache";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatterCreator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/extractors/NestedTableAwareObjectFormatter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isStringLiteral";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

