/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkCropImageFilter_h
#define sitkCropImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class CropImageFilter
\brief Decrease the image size by cropping the image by an itk::Size at both the upper and lower bounds of the largest possible region.

CropImageFilter changes the image boundary of an image by removing pixels outside the target region. The target region is not specified in advance, but calculated in BeforeThreadedGenerateData() .

This filter uses ExtractImageFilter to perform the cropping.
\sa itk::simple::Crop for the procedural interface
\sa itk::CropImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT CropImageFilter : public ImageFilter {
    public:
      using Self = CropImageFilter;

      /** Destructor */
      virtual ~CropImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      CropImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = NonLabelPixelIDTypeList;
\

      /**
       * Set/Get the cropping sizes for the upper and lower boundaries.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetLowerBoundaryCropSize ( std::vector<unsigned int> LowerBoundaryCropSize ) { this->m_LowerBoundaryCropSize = std::move(LowerBoundaryCropSize); return *this; }

      /**
       * Set/Get the cropping sizes for the upper and lower boundaries.
       */
      std::vector<unsigned int> GetLowerBoundaryCropSize() const { return this->m_LowerBoundaryCropSize; }\

      /**
       * Set/Get the cropping sizes for the upper and lower boundaries.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUpperBoundaryCropSize ( std::vector<unsigned int> UpperBoundaryCropSize ) { this->m_UpperBoundaryCropSize = std::move(UpperBoundaryCropSize); return *this; }

      /**
       * Set/Get the cropping sizes for the upper and lower boundaries.
       */
      std::vector<unsigned int> GetUpperBoundaryCropSize() const { return this->m_UpperBoundaryCropSize; }

      /** Name of this class */
      std::string GetName() const { return std::string ("CropImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
#ifndef SWIG
      Image Execute ( Image&& image1 );
#endif
      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /* 	odo what does this itk_type attribute do? */
      std::vector<unsigned int>  m_LowerBoundaryCropSize{std::vector<unsigned int>(3, 0)};

      /* 	odo what does this itk_type attribute do? */
      std::vector<unsigned int>  m_UpperBoundaryCropSize{std::vector<unsigned int>(3, 0)};


      bool m_InPlace{false};
    };

    /**\
     * \brief Decrease the image size by cropping the image by an itk::Size at both the upper and lower bounds of the largest possible region.
     *
     * This function directly calls the execute method of CropImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::CropImageFilter for the object oriented interface
     * @{
     */
#ifndef SWIG
     SITKBasicFilters_EXPORT Image Crop ( Image&& image1, std::vector<unsigned int> lowerBoundaryCropSize = std::vector<unsigned int>(3, 0), std::vector<unsigned int> upperBoundaryCropSize = std::vector<unsigned int>(3, 0) );
#endif
     SITKBasicFilters_EXPORT Image Crop ( const Image& image1, std::vector<unsigned int> lowerBoundaryCropSize = std::vector<unsigned int>(3, 0), std::vector<unsigned int> upperBoundaryCropSize = std::vector<unsigned int>(3, 0) );

     /** @} */
}
#endif
