/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.crossdc.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.crossdc.common.MirroredSolrRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirroredSolrRequestSerializer
implements Serializer<MirroredSolrRequest<?>>,
Deserializer<MirroredSolrRequest<?>> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public MirroredSolrRequest<?> deserialize(String topic, byte[] data) {
        Object request;
        Map requestMap;
        try (JavaBinCodec codec = new JavaBinCodec();){
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            try {
                requestMap = (Map)codec.unmarshal((InputStream)bais);
                if (log.isTraceEnabled()) {
                    log.trace("Deserialized class={} solrRequest={}", (Object)requestMap.getClass().getName(), (Object)requestMap);
                }
            }
            catch (Exception e) {
                log.error("Exception unmarshalling JavaBin", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        catch (IOException e) {
            log.error("Error in deserialize", (Throwable)e);
            throw new RuntimeException(e);
        }
        MirroredSolrRequest.Type type = MirroredSolrRequest.Type.get((String)requestMap.get("type"));
        int attempt = Integer.parseInt(String.valueOf(requestMap.getOrDefault("attempt", "-1")));
        long submitTimeNanos = Long.parseLong(String.valueOf(requestMap.getOrDefault("submitTimeNanos", "-1")));
        ModifiableSolrParams params = requestMap.get("params") != null ? ModifiableSolrParams.of((SolrParams)new MapSolrParams((Map)requestMap.get("params"))) : new ModifiableSolrParams();
        if (type == MirroredSolrRequest.Type.UPDATE) {
            List deletesQuery;
            UpdateRequest updateRequest = request = new UpdateRequest();
            List docs = (List)requestMap.get("docs");
            if (docs != null) {
                updateRequest.add((Collection)docs);
            } else {
                updateRequest.add(new String[]{"id", "1"});
                updateRequest.getDocumentsMap().clear();
            }
            List deletes = (List)requestMap.get("deletes");
            if (deletes != null) {
                updateRequest.deleteById(deletes);
            }
            if ((deletesQuery = (List)requestMap.get("deleteQuery")) != null) {
                for (String delQuery : deletesQuery) {
                    updateRequest.deleteByQuery(delQuery);
                }
            }
            updateRequest.setParams(params);
        } else if (type == MirroredSolrRequest.Type.ADMIN) {
            CollectionParams.CollectionAction action = CollectionParams.CollectionAction.get((String)params.get("action"));
            if (action == null) {
                throw new RuntimeException("Missing 'action' parameter! " + String.valueOf(requestMap));
            }
            request = new MirroredSolrRequest.MirroredAdminRequest(action, params);
            if (log.isDebugEnabled()) {
                log.debug("Mirrored Admin request={}", (Object)((MirroredSolrRequest.MirroredAdminRequest)((Object)request)).jsonStr());
            }
        } else if (type == MirroredSolrRequest.Type.CONFIGSET) {
            ArrayList<ContentStream> contentStreams = null;
            String m = (String)requestMap.get("method");
            SolrRequest.METHOD method = SolrRequest.METHOD.valueOf((String)m);
            ArrayList<String> csNames = new ArrayList<String>();
            List streamsList = (List)requestMap.get("contentStreams");
            if (streamsList != null) {
                contentStreams = new ArrayList<ContentStream>();
                for (Map streamMap : streamsList) {
                    String contentType = (String)streamMap.get("contentType");
                    String name = (String)streamMap.get("name");
                    csNames.add(name);
                    String sourceInfo = (String)streamMap.get("sourceInfo");
                    byte[] content = (byte[])streamMap.get("content");
                    MirroredSolrRequest.ExposedByteArrayContentStream ecs = new MirroredSolrRequest.ExposedByteArrayContentStream(content, sourceInfo, contentType);
                    ecs.setName(name);
                    contentStreams.add((ContentStream)ecs);
                }
            }
            request = new MirroredSolrRequest.MirroredConfigSetRequest(method, (SolrParams)params, contentStreams);
            if (log.isDebugEnabled()) {
                log.debug("Mirrored configSet method={}, req={}, streams={}", new Object[]{request.getMethod(), request.getParams(), csNames});
            }
        } else {
            throw new RuntimeException("Unknown request type: " + String.valueOf(requestMap));
        }
        return new MirroredSolrRequest(type, attempt, request, submitTimeNanos);
    }

    public byte[] serialize(String topic, MirroredSolrRequest<?> request) {
        byte[] byArray;
        SolrRequest<?> solrRequest = request.getSolrRequest();
        if (log.isTraceEnabled()) {
            log.trace("serialize request={}", request);
        }
        JavaBinCodec codec = new JavaBinCodec(null);
        try {
            ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream();
            HashMap map = CollectionUtil.newHashMap((int)8);
            map.put("attempt", request.getAttempt());
            map.put("submitTimeNanos", request.getSubmitTimeNanos());
            map.put("params", solrRequest.getParams());
            map.put("type", request.getType().toString());
            if (solrRequest instanceof UpdateRequest) {
                UpdateRequest update = (UpdateRequest)solrRequest;
                map.put("docs", update.getDocuments());
                map.put("deletes", update.getDeleteById());
                map.put("deleteQuery", update.getDeleteQuery());
            } else if (solrRequest instanceof MirroredSolrRequest.MirroredConfigSetRequest) {
                MirroredSolrRequest.MirroredConfigSetRequest config = (MirroredSolrRequest.MirroredConfigSetRequest)solrRequest;
                map.put("method", config.getMethod().toString());
                if (config.getContentStreams() != null) {
                    ArrayList streamsList = new ArrayList();
                    for (ContentStream cs : config.getContentStreams()) {
                        HashMap<String, Object> streamMap = new HashMap<String, Object>();
                        streamMap.put("name", cs.getName());
                        streamMap.put("contentType", cs.getContentType());
                        streamMap.put("sourceInfo", cs.getSourceInfo());
                        MirroredSolrRequest.ExposedByteArrayContentStream ecs = MirroredSolrRequest.ExposedByteArrayContentStream.of(cs);
                        streamMap.put("content", ecs.byteArray());
                        streamsList.add(streamMap);
                    }
                    map.put("contentStreams", streamsList);
                }
            }
            codec.marshal((Object)map, (OutputStream)baos);
            byArray = baos.byteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    codec.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.error("Error in serialize", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        codec.close();
        return byArray;
    }

    public final void close() {
        super.close();
    }

    private static final class ExposedByteArrayOutputStream
    extends ByteArrayOutputStream {
        ExposedByteArrayOutputStream() {
        }

        byte[] byteArray() {
            return this.buf;
        }
    }
}

