/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateUnit;

public class CoordinateAxisTimeHelper {
    private final Calendar calendar;
    private final CalendarDateUnit dateUnit;

    public CoordinateAxisTimeHelper(Calendar calendar, String unitString) {
        this.calendar = calendar;
        this.dateUnit = unitString == null ? null : CalendarDateUnit.withCalendar(calendar, unitString);
    }

    public CalendarDate makeCalendarDateFromOffset(double offset) {
        return this.dateUnit.makeCalendarDate(offset);
    }

    public CalendarDate makeCalendarDateFromOffset(String offset) {
        return CalendarDateFormatter.isoStringToCalendarDate(this.calendar, offset);
    }
}

