/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.proj.Projection;

public class Eckert1Projection
extends Projection {
    private static final double FC = 0.9213177319235613;
    private static final double RP = 0.3183098861837907;

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        out.x = 0.9213177319235613 * lplam * (1.0 - 0.3183098861837907 * Math.abs(lpphi));
        out.y = 0.9213177319235613 * lpphi;
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        out.y = xyy / 0.9213177319235613;
        out.x = xyx / (0.9213177319235613 * (1.0 - 0.3183098861837907 * Math.abs(out.y)));
        return out;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Eckert I";
    }
}

